<div class="content-wrapper">
    <!-- Content Header (Page header) -->
    <!-- Main content -->
    <section class="content-header">
        <div class="container-fluid">
            <div class="row mb-2">
                <div class="col-sm-6">
                    <h4>Manage Featured Section (Show Products Exclusively)</h4>
                </div>
                <div class="col-sm-6">
                    <ol class="breadcrumb float-sm-right">
                        <li class="breadcrumb-item"><a href="<?= base_url('admin/home') ?>">Home</a></li>
                        <li class="breadcrumb-item active">Featured Section </li>
                    </ol>
                </div>
            </div>
        </div><!-- /.container-fluid -->
    </section>
    <section class="content">
        <div class="container-fluid">
            <div class="row">
                <div class="col-md-12">
                    <div class="card card-info">
                        <!-- form start -->
                        <form class="form-horizontal form-submit-event" action="<?= base_url('admin/Featured_sections/add_featured_section'); ?>" method="POST" enctype="multipart/form-data">
                            <?php if (isset($fetched_data[0]['id'])) { ?>
                                <input type="hidden" id="edit_featured_section" name="edit_featured_section" value="<?= @$fetched_data[0]['id'] ?>">
                                <input type="hidden" id="update_id" name="update_id" value="1">
                            <?php } ?>
                            <div class="card-body">
                                <div class="form-group row">
                                    <label for="title" class="control-label">Title for section <span class='text-danger text-sm'>*</span></label>
                                    <div class="col-md-12">
                                        <input type="text" class="form-control" name="title" id="title" value="<?= (isset($fetched_data[0]['title']) ? stripslashes($fetched_data[0]['title']) : '') ?>" placeholder="Title">
                                    </div>
                                </div>
                                <div class="form-group row">
                                    <label for="short_description" class="control-label">Short description <span class='text-danger text-sm'>*</span></label>
                                    <div class="col-md-12">
                                        <input type="text" class="form-control" name="short_description" id="short_description" value="<?= (isset($fetched_data[0]['short_description']) ? stripslashes($fetched_data[0]['short_description']) : '') ?>" placeholder="Short description">
                                    </div>
                                </div>
                                <div class="form-group row select-categories">
                                    <label for="categories" class="control-label">Categories</label>
                                    <div class="col-md-12">
                                        <select name="categories[]" class=" select_multiple w-100" multiple data-placeholder=" Type to search and select categories">
                                            <option value=""><?= (isset($categories) && empty($categories)) ? 'No Categories Exist' : 'Select Categories' ?>
                                            </option>
                                            <?php
                                            $selected_val = (isset($fetched_data[0]['id']) &&  !empty($fetched_data[0]['id'])) ? $fetched_data[0]['categories'] : '';
                                            $selected_vals = explode(',', $selected_val);
                                            echo get_categories_option_html($categories, $selected_vals);

                                            ?>
                                        </select>
                                    </div>
                                </div>

                                <div class="form-group row">
                                    <?php
                                    $style = ['default', 'style_1', 'style_2', 'style_3', 'style_4'];
                                    ?>
                                    <label for="style" class="control-label">Style <span class='text-danger text-sm'>*</span></label>
                                    <div class="col-md-12">
                                        <select name="style" class="form-control">
                                            <option value=" ">Select Style</option>
                                            <?php foreach ($style as $row) { ?>
                                                <option value="<?= $row ?>" <?= (isset($fetched_data[0]['style']) && $fetched_data[0]['style'] == $row) ? 'Selected' : '' ?>><?= ucwords(str_replace('_', ' ', $row)) ?></option>
                                            <?php } ?>
                                        </select>
                                        <?php ?>
                                    </div>
                                </div>

                                <div class="form-group row">
                                    <?php
                                    $product_type = ['new_added_products', 'products_on_sale', 'top_rated_products', 'most_selling_products', 'custom_products', 'digital_product'];
                                    ?>
                                    <label for="product_type" class="control-label">Product Types <span class='text-danger text-sm'> * </span></label>
                                    <div class="col-md-12">
                                        <select name="product_type" class="form-control product_type">
                                            <option value=" ">Select Types</option>
                                            <?php foreach ($product_type as $row) { ?>
                                                <option value="<?= $row ?>" <?= (isset($fetched_data[0]['id']) &&  $fetched_data[0]['product_type'] == $row) ? "Selected" : "" ?>><?= ucwords(str_replace('_', ' ', $row)) ?></option>
                                            <?php
                                            } ?>
                                        </select>
                                        <?php ?>
                                    </div>
                                </div>

                                <!-- for custom product -->

                                <div class="form-group row custom_products <?= (isset($fetched_data[0]['id'])  && $fetched_data[0]['product_type'] == 'custom_products') ? '' : 'd-none' ?>">
                                    <label for="product_ids" class="control-label">Products *</label>
                                    <div class="col-md-12">
                                        <select name="product_ids[]" class="search_admin_product w-100" multiple data-placeholder=" Type to search and select products" onload="multiselect()">
                                            <?php
                                            if (isset($fetched_data[0]['id'])) {
                                                $product_id = explode(",", $fetched_data[0]['product_ids']);

                                                foreach ($product_details as $row) {
                                            ?>
                                                    <option value="<?= $row['id'] ?>" selected><?= $row['name'] ?></option>
                                            <?php
                                                }
                                            }

                                            ?>
                                        </select>
                                    </div>
                                </div>

                                <!-- for digital product -->

                                <div class="form-group row digital_products <?= (isset($fetched_data[0]['id'])  && $fetched_data[0]['product_type'] == 'digital_product') ? '' : 'd-none' ?>">
                                    <label for="digital_product_ids" class="control-label">Products *</label>
                                    <div class="col-md-12">
                                        <select name="digital_product_ids[]" class="search_admin_digital_product w-100" multiple data-placeholder=" Type to search and select products" onload="multiselect()">
                                            <?php
                                            if (isset($fetched_data[0]['id'])) {
                                                $product_id = explode(",", $fetched_data[0]['product_ids']);

                                                foreach ($product_details as $row) {

                                            ?>
                                                    <option value="<?= $row['id'] ?>" selected><?= $row['name'] ?></option>
                                            <?php
                                                }
                                            }

                                            ?>
                                        </select>
                                    </div>
                                </div>

                                <hr class="mt-4">
                                <h4 class="bg-light m-0 px-2 py-3">SEO Configuration</h4>

                                <div class="d-flex bg-light">
                                    <div class="form-group col-sm-6">
                                        <label for="seo_page_title" class="form-label form-label-sm d-flex">
                                            SEO Page Title
                                        </label>
                                        <input type="text" class="form-control" id="seo_page_title"
                                            placeholder="SEO Page Title" name="seo_page_title"
                                            value="<?= isset($fetched_data[0]['seo_page_title']) ? output_escaping($fetched_data[0]['seo_page_title']) : "" ?>">
                                    </div>

                                    <div class="form-group col-sm-6">
                                        <label for="seo_meta_keywords" class="form-label form-label-sm d-flex">
                                            SEO Meta Keywords
                                        </label>
                                        <input class='tags bg-white' id='seo_meta_keywords' placeholder="SEO Meta Keywords" name="seo_meta_keywords" value="<?= isset($fetched_data[0]['seo_meta_keywords']) ? output_escaping($fetched_data[0]['seo_meta_keywords']) : "" ?>" />
                                    </div>
                                </div>
                                <div class="d-flex bg-light">

                                    <div class="form-group col-sm-6">
                                        <label for="seo_meta_description" class="form-label form-label-sm d-flex">
                                            SEO Meta Description
                                        </label>
                                        <textarea class="form-control" id="seo_meta_description"
                                            placeholder="SEO Meta Keywords" name="seo_meta_description"><?= isset($fetched_data[0]['seo_meta_description']) ? output_escaping($fetched_data[0]['seo_meta_description']) : "" ?></textarea>
                                    </div>

                                    <div class="col-sm-12 col-md-6">
                                        <div class="form-group">
                                            <label for="image">SEO Open Graph Image <small>(Recommended Size : 131 x 131 pixels)</small></label>
                                            <div class="col-sm-10">
                                                <div class='col-md-12'>
                                                    <a class="uploadFile img btn btn-primary text-white btn-sm" data-input='seo_og_image' data-isremovable='1' 
                                                    data-is-multiple-uploads-allowed='0' data-toggle="modal" data-target="#media-upload-modal" value="Upload"><i class='fa fa-upload'></i> Upload</a>
                                                </div>
                                                <?php
                                                if (!empty(@$fetched_data[0]['seo_og_image'])) {
                                                ?>
                                                    <label class="text-danger mt-3">*Only Choose When Update is
                                                        necessary</label>
                                                    <div class="container-fluid row image-upload-section">
                                                        <div class="col-md-12 col-sm-12 shadow p-3 bg-white rounded text-center grow image">
                                                            <div class='image-upload-div'><img class="img-fluid mb-2"
                                                                    src="<?= base_url() . str_replace('//', '/', $fetched_data[0]['seo_og_image']) ?>"
                                                                    alt="Image Not Found"></div>
                                                            <input type="hidden" name="seo_og_image" value='<?= $fetched_data[0]['seo_og_image'] ?>'>
                                                        </div>
                                                    </div>
                                                <?php
                                                } else { ?>
                                                    <div class="container-fluid row image-upload-section">
                                                        <div
                                                            class="col-md-12 col-sm-12 shadow p-3 mb-5 bg-white rounded m-4 text-center grow image d-none">
                                                        </div>
                                                    </div>
                                                <?php } ?>
                                            </div>
                                        </div>
                                    </div>
                                </div>

                                <div class="form-group my-3">
                                    <button type="reset" class="btn btn-warning">Reset</button>
                                    <button type="submit" class="btn btn-success" id="submit_btn"><?= (isset($fetched_data[0]['id'])) ? 'Update Featured Section' : 'Add Featured Section' ?></button>
                                </div>
                            </div>

                        </form>
                    </div>
                </div>
                <!--/.card-->
            </div>
            <div class="modal fade edit-modal-lg" tabindex="-1" role="dialog" aria-labelledby="myLargeModalLabel" aria-hidden="true" id="feature_section_edit_model">
                <div class="modal-dialog modal-lg">
                    <div class="modal-content">
                        <div class="modal-header">
                            <h5 class="modal-title" id="exampleModalLongTitle">Edit Fetured Section Details</h5>
                            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                <span aria-hidden="true">&times;</span>
                            </button>
                        </div>
                        <div class="modal-body">
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-md-12 main-content">
                <div class="card content-area p-4">
                    <div class="card-head">
                        <h4 class="card-title">Featured Section</h4>
                    </div>
                    <div class="card-innr">
                        <div class="gaps-1-5x"></div>
                        <table class='table-striped' data-toggle="table" data-url="<?= base_url('admin/Featured_sections/get_section_list') ?>" data-click-to-select="true" data-side-pagination="server" data-pagination="true" data-page-list="[5, 10, 20, 50, 100, 200]" data-search="true" data-show-columns="true" data-show-refresh="true" data-trim-on-search="false" data-sort-name="id" data-sort-order="desc" data-mobile-responsive="true" data-toolbar="" data-show-export="true" data-maintain-selected="true" data-export-types='["txt","excel"]' data-query-params="queryParams">
                            <thead>
                                <tr>
                                    <th data-field="id" data-sortable="true">ID</th>
                                    <th data-field="title" data-sortable="true">Title</th>
                                    <th data-field="short_description" data-sortable="false">Short description</th>
                                    <th data-field="style" data-sortable="false">Style</th>
                                    <th data-field="categories" data-sortable="true">Categories</th>
                                    <th data-field="product_ids" data-sortable="true">Product ids</th>
                                    <th data-field="product_type" data-sortable="true">Product Type</th>
                                    <th data-field="date" data-sortable="true">Date</th>
                                    <th data-field="operate" data-sortable="false">Actions</th>
                                </tr>
                            </thead>
                        </table>
                    </div><!-- .card-innr -->
                </div><!-- .card -->
            </div>
        </div>
        <!-- /.row -->
</div><!-- /.container-fluid -->
</section>
<!-- /.content -->
</div>